rm(list=objects())
setwd("~/Desktop/Experiments/Simulations/Results")

type <- 2
path <- "Missing Observations"
K <- 3
M <- 100 # number of experiments############a
N <- 500
p_list <- rep(NA,20)

# record the errors
Error_missSBM <- matrix(NA, ncol = 3, nrow = 20)
Error_Var <- matrix(NA, ncol = 3, nrow = 20)
Error_true_Z <- matrix(NA, ncol = 3, nrow = 20)
Error_softImpute <- matrix(NA, ncol = 3, nrow = 20)

for (n in 1:20){
  res <- readRDS(paste0(path, "/r_", n,".RDS"))
  p_list[n] <- res$p
  Error_missSBM[n,] <- quantile(res$Error_missSBM, probs = c(0.25, 0.5, 0.75))
  
  Error_Var[n,] <- quantile(res$Error_Var, probs = c(0.25, 0.5, 0.75))
  
  Error_softImpute[n,] <- quantile(res$Error_softImpute, probs = c(0.25, 0.5, 0.75))
  
  Error_true_Z[n,] <- quantile(res$Error_true_Z, probs = c(0.25, 0.5, 0.75))
  
  Error_true_Z[n,] <- quantile(res$Error_true_Z, probs = c(0.25, 0.5, 0.75))
}

plot(x = p_list, y = Error_softImpute[,2], type = 'l', col = 'green',
     xlab = "Sampling rate p", ylab = "Error", log = "x", ylim = c(0, 0.1))
lines(x = p_list, y = Error_softImpute[,1], lty = 3, col = 'green')
lines(x = p_list, y = Error_softImpute[,3], lty = 3, col = 'green')

lines(x = p_list, y = Error_true_Z[,2], col = 'black')
lines(x = p_list, y = Error_true_Z[,1], lty = 3, col = 'black')
lines(x = p_list, y = Error_true_Z[,3], lty = 3, col = 'black')

lines(x = p_list, y = Error_Var[,2], col = 'blue')
lines(x = p_list, y = Error_Var[,1], lty = 3, col = 'blue')
lines(x = p_list, y = Error_Var[,3], lty = 3, col = 'blue')

lines(x = p_list, y = Error_missSBM[,2], col = 'red')
lines(x = p_list, y = Error_missSBM[,1], lty = 3, col = 'red')
lines(x = p_list, y = Error_missSBM[,3], lty = 3, col = 'red')